/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.item;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import lotr.common.LOTRLevelData;
import lotr.common.LOTRPlayerData;
import lotr.common.fac.LOTRFaction;
import lotr.common.item.LOTRItemSword;
import lotr.common.item.LOTRMaterial;
import lotr.common.item.LOTRWeaponStats;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class LOTRItemTwoHandedSword
extends LOTRItemSword {
    public LOTRItemTwoHandedSword(LOTRMaterial material) {
        super(material.toToolMaterial());
    }

    public LOTRItemTwoHandedSword(Item.ToolMaterial material) {
        super(material);
        LOTRWeaponStats.registerMeleeSpeed(LOTRItemTwoHandedSword.class, 0.7f);
        LOTRWeaponStats.registerMeleeReach(LOTRItemTwoHandedSword.class, 1.25f);
        if (material == Item.ToolMaterial.IRON) {
            this.lotrWeaponDamage = 6.0f;
        }
    }

    public EnumAction func_77661_b(ItemStack itemstack) {
        return EnumAction.block;
    }

    @Override
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean advanced) {
        if (player != null) {
            String factionName;
            int reputation;
            LOTRPlayerData playerData = LOTRLevelData.getData(player);
            LOTRFaction pledgeFaction = playerData.getPledgeFaction();
            if (pledgeFaction != null && this.getPriorityFactionType(pledgeFaction.getFactionTypes()) == LOTRFaction.FactionType.TYPE_TREE) {
                reputation = Math.round(playerData.getAlignment(pledgeFaction));
                factionName = pledgeFaction.factionName();
                if (reputation < 10000) {
                    list.add(EnumChatFormatting.GOLD + I18n.func_135052_a((String)"item.armor.pledge", (Object[])new Object[]{factionName}));
                    list.add("");
                    list.add(EnumChatFormatting.GOLD + "\u2694 " + I18n.func_135052_a((String)"item.hammer.bonusDamage.info", (Object[])new Object[]{reputation, 10000}));
                } else if (reputation >= 10000 && reputation < 15000) {
                    list.add(EnumChatFormatting.GOLD + I18n.func_135052_a((String)"item.armor.pledge", (Object[])new Object[]{factionName}));
                    list.add("");
                    list.add(EnumChatFormatting.GOLD + "\u2694 " + I18n.func_135052_a((String)"item.hammer.bonusDamage.info", (Object[])new Object[]{reputation, 20000}));
                    list.add(EnumChatFormatting.GOLD + "\u2694 " + I18n.func_135052_a((String)"item.hammer.entDamage.active", (Object[])new Object[]{"3.0"}));
                } else if (reputation >= 20000) {
                    list.add(EnumChatFormatting.GOLD + I18n.func_135052_a((String)"item.armor.pledge", (Object[])new Object[]{factionName}));
                    list.add("");
                    list.add(EnumChatFormatting.GOLD + "\u2694 " + I18n.func_135052_a((String)"item.hammer.bonusDamage.active", (Object[])new Object[]{"2.0"}));
                    list.add(EnumChatFormatting.GOLD + "\u2694 " + I18n.func_135052_a((String)"item.hammer.entDamage.active", (Object[])new Object[]{"3.0"}));
                }
            }
            if (pledgeFaction != null && this.getPriorityFactionType(pledgeFaction.getFactionTypes()) == LOTRFaction.FactionType.TYPE_DWARF) {
                reputation = Math.round(playerData.getAlignment(pledgeFaction));
                factionName = pledgeFaction.factionName();
                if (reputation < 10000) {
                    list.add(EnumChatFormatting.GOLD + I18n.func_135052_a((String)"item.armor.pledge", (Object[])new Object[]{factionName}));
                    list.add("");
                    list.add(EnumChatFormatting.GOLD + "\u2694 " + I18n.func_135052_a((String)"item.hammer.bonusDamage.info", (Object[])new Object[]{reputation, 10000}));
                } else {
                    list.add(EnumChatFormatting.GOLD + I18n.func_135052_a((String)"item.armor.pledge", (Object[])new Object[]{factionName}));
                    list.add("");
                    list.add(EnumChatFormatting.GOLD + "\u2694 " + I18n.func_135052_a((String)"item.hammer.dwarfDamage.active", (Object[])new Object[]{"2.0"}));
                }
            }
            if (pledgeFaction != null && this.getPriorityFactionType(pledgeFaction.getFactionTypes()) == LOTRFaction.FactionType.TYPE_ORC) {
                reputation = Math.round(playerData.getAlignment(pledgeFaction));
                factionName = pledgeFaction.factionName();
                if (reputation < 10000) {
                    list.add(EnumChatFormatting.RED + I18n.func_135052_a((String)"item.armor.pledge", (Object[])new Object[]{factionName}));
                    list.add("");
                    list.add(EnumChatFormatting.RED + "\u2694 " + I18n.func_135052_a((String)"item.hammer.bonusDamage.info", (Object[])new Object[]{reputation, 10000}));
                } else {
                    list.add(EnumChatFormatting.RED + I18n.func_135052_a((String)"item.armor.pledge", (Object[])new Object[]{factionName}));
                    list.add("");
                    list.add(EnumChatFormatting.RED + "\u2694 " + I18n.func_135052_a((String)"item.hammer.bonusDamage.active", (Object[])new Object[]{"2.0"}));
                }
            }
            if (pledgeFaction != null && this.getPriorityFactionType(pledgeFaction.getFactionTypes()) == LOTRFaction.FactionType.TYPE_TROLL) {
                reputation = Math.round(playerData.getAlignment(pledgeFaction));
                factionName = pledgeFaction.factionName();
                list.add(EnumChatFormatting.GREEN + I18n.func_135052_a((String)"item.armor.pledge", (Object[])new Object[]{factionName}));
                if (reputation < 20000) {
                    list.add("");
                    list.add(EnumChatFormatting.GREEN + "\u2694 " + I18n.func_135052_a((String)"item.hammer.bonusDamage.info", (Object[])new Object[]{reputation, 20000}));
                } else {
                    list.add("");
                    list.add(EnumChatFormatting.GREEN + "\u2694 " + I18n.func_135052_a((String)"item.hammer.trollDamage.active", (Object[])new Object[]{"2.0"}));
                }
            }
            if (pledgeFaction != null && this.getPriorityFactionType(pledgeFaction.getFactionTypes()) == LOTRFaction.FactionType.TYPE_MAN) {
                reputation = Math.round(playerData.getAlignment(pledgeFaction));
                factionName = pledgeFaction.factionName();
                if (reputation < 5000) {
                    list.add(EnumChatFormatting.YELLOW + I18n.func_135052_a((String)"item.armor.pledge", (Object[])new Object[]{factionName}));
                    list.add("");
                    list.add(EnumChatFormatting.YELLOW + "\u2694 " + I18n.func_135052_a((String)"item.hammer.bonusDamage.info", (Object[])new Object[]{reputation, 5000}));
                } else if (reputation >= 5000 && reputation < 10000) {
                    list.add(EnumChatFormatting.YELLOW + I18n.func_135052_a((String)"item.armor.pledge", (Object[])new Object[]{factionName}));
                    list.add("");
                    list.add(EnumChatFormatting.YELLOW + "\u2694 " + I18n.func_135052_a((String)"item.hammer.bonusDamage.info", (Object[])new Object[]{reputation, 10000}));
                    list.add(EnumChatFormatting.YELLOW + "\u2694 " + I18n.func_135052_a((String)"item.hammer.manDamage.active", (Object[])new Object[]{"3.0"}));
                } else if (reputation >= 10000) {
                    list.add(EnumChatFormatting.YELLOW + I18n.func_135052_a((String)"item.armor.pledge", (Object[])new Object[]{factionName}));
                    list.add("");
                    list.add(EnumChatFormatting.YELLOW + "\u2694 " + I18n.func_135052_a((String)"item.hammer.bonusDamage.active", (Object[])new Object[]{"2.0"}));
                    list.add(EnumChatFormatting.YELLOW + "\u2694 " + I18n.func_135052_a((String)"item.hammer.manDamage.active", (Object[])new Object[]{"3.0"}));
                }
            }
        }
    }

    private LOTRFaction.FactionType getPriorityFactionType(Set<LOTRFaction.FactionType> factionTypes) {
        if (factionTypes.contains((Object)LOTRFaction.FactionType.TYPE_ELF)) {
            return LOTRFaction.FactionType.TYPE_ELF;
        }
        if (factionTypes.contains((Object)LOTRFaction.FactionType.TYPE_DWARF)) {
            return LOTRFaction.FactionType.TYPE_DWARF;
        }
        if (factionTypes.contains((Object)LOTRFaction.FactionType.TYPE_TREE)) {
            return LOTRFaction.FactionType.TYPE_TREE;
        }
        if (factionTypes.contains((Object)LOTRFaction.FactionType.TYPE_MAN)) {
            return LOTRFaction.FactionType.TYPE_MAN;
        }
        if (factionTypes.contains((Object)LOTRFaction.FactionType.TYPE_ORC)) {
            return LOTRFaction.FactionType.TYPE_ORC;
        }
        if (factionTypes.contains((Object)LOTRFaction.FactionType.TYPE_TROLL)) {
            return LOTRFaction.FactionType.TYPE_TROLL;
        }
        return LOTRFaction.FactionType.TYPE_FREE;
    }

    @Override
    public boolean func_77644_a(ItemStack itemstack, EntityLivingBase target, EntityLivingBase attacker) {
        World world = attacker.field_70170_p;
        itemstack.func_77972_a(1, attacker);
        this.useTwoHandedSword(itemstack, world, target, attacker);
        return true;
    }

    public void useTwoHandedSword(ItemStack itemstack, World world, EntityLivingBase target, EntityLivingBase user) {
        user.func_71038_i();
        if (world.field_72995_K) {
            return;
        }
        double radius = 6.0;
        Vec3 position = Vec3.func_72443_a((double)user.field_70165_t, (double)user.field_70163_u, (double)user.field_70161_v);
        Vec3 look = user.func_70040_Z();
        if (look == null) {
            return;
        }
        Vec3 sight = position.func_72441_c(look.field_72450_a * radius, look.field_72448_b * radius, look.field_72449_c * radius);
        float sightWidth = 2.0f;
        List entities = world.func_72839_b((Entity)user, user.field_70121_D.func_72321_a(look.field_72450_a * radius, look.field_72448_b * radius, look.field_72449_c * radius).func_72314_b((double)sightWidth, (double)sightWidth, (double)sightWidth));
        if (entities == null) {
            return;
        }
        ArrayList<EntityLivingBase> targets = new ArrayList<EntityLivingBase>();
        for (Object element : entities) {
            EntityLivingBase entity;
            if (!(element instanceof EntityLivingBase) || (entity = (EntityLivingBase)element) == user || entity == target || entity instanceof EntityPlayer && (!(user instanceof EntityPlayer) ? user instanceof EntityLiving && ((EntityLiving)user).func_70638_az() != entity : !MinecraftServer.func_71276_C().func_71219_W())) continue;
            float width = 1.0f;
            AxisAlignedBB axisalignedbb = entity.field_70121_D.func_72314_b((double)width, (double)width, (double)width);
            MovingObjectPosition movingobjectposition = axisalignedbb.func_72327_a(position, sight);
            if (entity.field_70121_D == null || !axisalignedbb.func_72318_a(position) && movingobjectposition == null) continue;
            targets.add(entity);
        }
        if (targets.size() > 1) {
            Random random = new Random();
            float pitch = 0.9f + random.nextFloat() * 0.2f;
            float volume = 1.5f;
            world.func_72956_a((Entity)user, "lotr:aurochs.swing", volume, pitch);
        }
        for (EntityLivingBase entity : targets) {
            if (entity == user || entity == target) continue;
            float strength = this.lotrWeaponDamage * 0.7f;
            if (user instanceof EntityPlayer) {
                entity.func_70097_a(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)user)), strength);
                continue;
            }
            entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)user), strength);
        }
    }
}

